// Detection script that runs in page context to check for GHL Nuxt data
(function() {
  let hasNuxt = false;
  let data = null;

  // Try Nuxt 3
  try {
    if (typeof useNuxtApp === 'function') {
      const nuxtApp = useNuxtApp();
      data = nuxtApp?.payload?.data?.pageData || {};
      if (data && (data.pageId || data.funnelId || data.stepId || data.locationId)) {
        hasNuxt = true;
      }
    }
  } catch(e) {
    // Nuxt 3 not available
  }

  // Try Nuxt 2
  if (!hasNuxt) {
    try {
      if (window.__NUXT__) {
        data = window.__NUXT__.data?.[0]?.pageData || window.__NUXT__.pageData || {};
        if (data && (data.pageId || data.funnelId || data.stepId || data.locationId)) {
          hasNuxt = true;
        }
      }
    } catch(e) {
      // Nuxt 2 not available
    }
  }

  // Send detection result back to content script
  window.postMessage({
    type: 'GHL_CUSTOM_DOMAIN_DETECTION',
    isGHL: hasNuxt,
    data: data
  }, '*');
})();
